package com.example.sefinsa_app.ui.rmd.Crear;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.provider.MediaStore;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.models.Articulo;
import com.google.android.material.textfield.TextInputEditText;

import java.util.ArrayList;

public class AgregarArticuloRMDAdapter extends RecyclerView.Adapter<AgregarArticuloRMDAdapter.ViewHolder> {

    private ArrayList<Articulo> articulos;
    private Context context;
    private FragmentActivity activity;
    private final CrearRMDFragment fragment;

    public AgregarArticuloRMDAdapter(CrearRMDFragment fragment, FragmentActivity activity, Context context, ArrayList<Articulo> articulos) {
        this.fragment = fragment;
        this.activity = activity;
        this.context = context;
        this.articulos = articulos;
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {
        private TextView tvArticulo;
        private TextView tvMarca;
        private TextView tvColor;
        private Button btnDetalle;
        private Button btnEditar;
        private Button btnFotos;
        private Button btnEliminar;

        public ViewHolder(@NonNull View view) {
            super(view);

            tvArticulo = view.findViewById(R.id.tvArticulo);
            tvMarca = view.findViewById(R.id.tvMarca);
            tvColor = view.findViewById(R.id.tvColor);
            btnDetalle = view.findViewById(R.id.btnDetalles);
            btnEditar = view.findViewById(R.id.btnEditar);
            btnFotos = view.findViewById(R.id.btnFotos);
            btnEliminar = view.findViewById(R.id.btnEliminar);
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.articulo_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, @SuppressLint("RecyclerView") int position) {
        Articulo articulo = articulos.get(position);

        holder.tvArticulo.setText("Artículo: " + articulo.getArticulo());
        holder.tvMarca.setText("Marca: " + articulo.getMarca());
        holder.tvColor.setText("Color: " + articulo.getColor());

        holder.btnDetalle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle("Detalles de las condiciones");
                builder.setMessage(articulo.getDetalleCondiciones());
                builder.setPositiveButton("Cerrar", null);
                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        holder.btnEditar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                View dialogLayout = LayoutInflater.from(context).inflate(R.layout.formulario_agregar_articulo_rmd, null);
                builder.setView(dialogLayout);

                TextInputEditText edTxtArticulo = dialogLayout.findViewById(R.id.etArticulo);
                TextInputEditText edTxtMarca = dialogLayout.findViewById(R.id.etMarca);
                TextInputEditText edTxtColor = dialogLayout.findViewById(R.id.etColor);
                TextInputEditText edTxtCondiciones = dialogLayout.findViewById(R.id.etDetallarCondiciones);

                edTxtArticulo.setText(articulo.getArticulo());
                edTxtMarca.setText(articulo.getMarca());
                edTxtColor.setText(articulo.getColor());
                edTxtCondiciones.setText(articulo.getDetalleCondiciones());

                builder.setTitle("Editar artículo");

                builder.setPositiveButton("Editar", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        String articuloE = edTxtArticulo.getText().toString();
                        String marcaE = edTxtMarca.getText().toString();
                        String colorE = edTxtColor.getText().toString();
                        String condicionesE = edTxtCondiciones.getText().toString();

                        articulo.setArticulo(articuloE);
                        articulo.setMarca(marcaE);
                        articulo.setColor(colorE);
                        articulo.setDetalleCondiciones(condicionesE);

                        holder.tvArticulo.setText("Artículo: " + articulo.getArticulo());
                        holder.tvMarca.setText("Marca: " + articulo.getMarca());
                        holder.tvColor.setText("Color: " + articulo.getColor());
                    }
                });

                builder.setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        holder.btnFotos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                View dialogLayout = LayoutInflater.from(context).inflate(R.layout.imagenes_rmd, null);
                builder.setView(dialogLayout);

                builder.setTitle("Agregar fotos del artículo");

                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) Button btnAbrirCamara = dialogLayout.findViewById(R.id.btnAbrirCamara);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) Button btnAbrirGaleria = dialogLayout.findViewById(R.id.btnAbrirGaleria);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) TextView tvCountFotos = dialogLayout.findViewById(R.id.tvCountFotos);
                @SuppressLint({"MissingInflatedId", "LocalSuppress"}) RecyclerView rvImagenes = dialogLayout.findViewById(R.id.rvImagenes);

                tvCountFotos.setText(articulo.getImagenes().size() + "/2");

                MostrarImagenesRMDAdapter adapter = new MostrarImagenesRMDAdapter(fragment, activity, context, articulo.getImagenes());
                RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
                rvImagenes.setLayoutManager(layoutManager);
                rvImagenes.setAdapter(adapter);

                btnAbrirCamara.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (articulo.getImagenes().size() == 2) {
                            Toast.makeText(context, "No se pueden agregar mas de dos fotos", Toast.LENGTH_SHORT).show();
                            return;
                        }
                        MostrarImagenesRMDAdapter adapter = new MostrarImagenesRMDAdapter(fragment, activity, context, articulo.getImagenes());
                        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
                        fragment.arbirCamara(position, adapter, layoutManager, rvImagenes, tvCountFotos);
                    }
                });

                btnAbrirGaleria.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (articulo.getImagenes().size() == 2) {
                            Toast.makeText(context, "No se pueden agregar mas de dos fotos", Toast.LENGTH_SHORT).show();
                            return;
                        }
                        MostrarImagenesRMDAdapter adapter = new MostrarImagenesRMDAdapter(fragment, activity, context, articulo.getImagenes());
                        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
                        fragment.abrirGaleria(position, adapter, layoutManager, rvImagenes, tvCountFotos);
                    }
                });

                builder.setPositiveButton("Cerrar", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        holder.btnEliminar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle("Eliminar artículo");
                builder.setMessage("¿Desea eliminar este artículo?");
                builder.setPositiveButton("Eliminar", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        articulos.remove(position);
                        notifyItemRemoved(position);
                        notifyItemRangeChanged(position, articulos.size());
                    }
                });

                builder.setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
        });
    }

    @Override
    public int getItemCount() { return articulos.size(); }
}
